package com.tencent.sample.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;

import com.tencent.connect.UserInfo;
import com.tencent.connect.auth.QQToken;
import com.tencent.open.log.SLog;
import com.tencent.sample.ThreadManager;
import com.tencent.sample.Util;
import com.tencent.sample.activitys.MainActivity;
import com.tencent.tauth.DefaultUiListener;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.UiError;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/**
 * 业务通过 server-side 方式授权登录获取到授权code
 * 模拟业务后台通过 授权code 获取到 accessToken + openId，并通过 UserInfo 接口获取到用户信息（昵称、头像链接）
 */
public class ServerSideUserInfoTestUtils {

    private static final String TAG = "ServerSideUtils";

    private static final String APP_KEY = "NehV4RbcOwITQEoA";

    private ServerSideUserInfoTestUtils() {
    }

    /**
     * 业务通过 server-side 获取授权code后，应该将 授权code 传回后台，由后台到QQ互联后台换取 accessToken + openId <br>
     *
     * 此处代码仅用于模拟业务后台，业务不应该将 APP_KEY 暴露在客户端代码中 <br>
     *
     * 此处模拟业务后台通过 授权code 获取到 accessToken + openId，并通过 UserInfo 接口获取到用户信息（昵称、头像链接）
     */
    public static void serverGetUserInfo(Activity activity, Handler mHandler, String authCode) {
        if (authCode == null || authCode.isEmpty()) {
            return;
        }

        updateUserInfo(MainActivity.mAppid, APP_KEY, authCode, activity, mHandler);
    }


    private static void updateUserInfo(final String appId, final String appKey, final String authCode, final Context context, final Handler mHandler) {

        final IUiListener listener = new DefaultUiListener() {

            @Override
            public void onError(UiError e) {

            }

            @Override
            public void onComplete(final Object response) {
                Message msg = new Message();
                msg.obj = response;
                msg.what = 0;
                mHandler.sendMessage(msg);
                new Thread() {

                    @Override
                    public void run() {
                        JSONObject json = (JSONObject) response;
                        if (json.has("figureurl")) {
                            Bitmap bitmap = null;
                            try {
                                bitmap = Util.getbitmap(json.getString("figureurl_qq_2"));
                            } catch (JSONException e) {
                                SLog.e(TAG, "Util.getBitmap() jsonException : " + e.getMessage());
                            }
                            Message msg = new Message();
                            msg.obj = bitmap;
                            msg.what = 1;
                            mHandler.sendMessage(msg);
                        }
                    }

                }.start();
            }

            @Override
            public void onCancel() {

            }
        };


        ThreadManager.getSubThreadHandler().post(new Runnable() {
            @Override
            public void run() {
                TokenData tokenData = getTokenAndOpenId(appId, appKey, authCode);
                if (tokenData == null) {
                    return;
                }

                QQToken qqToken = new QQToken(appId);
                qqToken.setAccessToken(tokenData.accessToken, (tokenData.expiresIn - System.currentTimeMillis()) / 1000 + "");
                qqToken.setOpenId(tokenData.openid);
                UserInfo info = new UserInfo(context, qqToken);
                info.getUserInfo(listener);
            }
        });


    }

    private static TokenData getTokenAndOpenId(String appId, String appKey, String authCode) {

        String url = "https://graph.qq.com/oauth2.0/token?grant_type=authorization_code&fmt=json&need_openid=1"
                + "&client_id=" + appId
                + "&client_secret=" + appKey
                + "&code=" + authCode
                + "&redirect_uri=" + urlEncode("auth://tauth.qq.com/");

        String httpData = httpGet(url);
        try {
            JSONObject json = new JSONObject(httpData);
            SLog.i(TAG, "getAccessToken() httpData = " + httpData);

            String accessToken = json.getString("access_token");
            long expiresIn = json.getLong("expires_in");
            String refreshToken = json.getString("refresh_token");
            String openid = json.getString("openid");

            if (!TextUtils.isEmpty(accessToken)
                    && expiresIn > 0
                    && !TextUtils.isEmpty(openid)
                    && !TextUtils.isEmpty(refreshToken)
            ) {

                TokenData data = new TokenData();

                data.accessToken = accessToken;
                data.expiresIn = expiresIn;
                data.openid = openid;
                data.refreshToken = refreshToken;

                return data;
            }

            SLog.e(TAG, "getAccessToken() json data error: " + httpData);
            return null;
        } catch (JSONException ignore) {
            SLog.e(TAG, "getAccessToken() json exception: " + httpData);
        }
        return null;
    }

    private static String urlEncode(String filePath) {
        try {
            return URLEncoder.encode(filePath, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(filePath);
        }
    }

    private static String httpGet(String urlStr) {
        try {
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();

            int responseCode = connection.getResponseCode();
            InputStream inputStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder response = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();

            SLog.d("ServerSideUtils", "httpGet responseCode = " + responseCode + " response = " + response);
            String ret = "";
            if (responseCode == HttpURLConnection.HTTP_OK) {
                String responseData = response.toString();
                // 处理响应数据
                ret = responseData;
            } else {
                // 处理错误情况
            }

            connection.disconnect();
            return ret;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private static class TokenData {
        String accessToken = "";
        long expiresIn = 0L;
        String openid = "";
        String refreshToken = "";
    }
}
