package com.tencent.sample.activitys;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.tencent.connect.UnionInfo;
import com.tencent.connect.UserInfo;
import com.tencent.connect.common.Constants;
import com.tencent.open.im.IM;
import com.tencent.open.miniapp.MiniApp;
import com.tencent.sample.BaseUIListener;
import com.tencent.sample.PermissionMgr;
import com.tencent.sample.R;
import com.tencent.sample.Util;
import com.tencent.tauth.DefaultUiListener;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Toast;

import java.util.ArrayList;

public class OtherApiActivity extends BaseActivity implements OnClickListener {

	private static final String KEY_TARGET_QQ_MINIAPP_ID = "target.miniappid";

	private static final String OPEN_CONNECT_DEMO_MINI_APP_ID = "1108108864";
	private static final String OPEN_CONNECT_DEMO_MINI_APP_PATH = "pages/tabBar/index/index";


	private static final String SHARE_PREF_NAME = "openSdk.pref";
	private static final String KEY_TARGET_QQ_UIN = "target.uin";

	private int mChosenIMType;
	private Tencent mTencent;

	private EditText mEtTargetUin = null;
	private EditText mEtTargetMiniAppId = null;
	private EditText mEtTargetMiniAppPath = null;
	private EditText mEtTargetMiniAppVersion = null;

	private static Intent mPrizeIntent = null;
	
	IUiListener commonChannelApiListener = new DefaultUiListener();

	/**
	 * 异步显示结果
	 */
	private Handler mHandler = new Handler(Looper.getMainLooper()) {
		@Override
		public void handleMessage(Message msg) {
			Context context = OtherApiActivity.this;
			String scope = msg.obj.toString();
			String response = msg.getData().getString("response");
			if (response != null) {
				// 换行显示
				response = response.replace(",", "\r\n");
			}
			AlertDialog dialog = new AlertDialog.Builder(context)
					.setMessage(response).setNegativeButton("知道啦", null)
					.create();
			dialog.setTitle(scope);
			dialog.show();
		};
	};

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		mTencent = MainActivity.mTencent;
		setBarTitle("其他");
		setLeftButtonEnable();
		setContentView(R.layout.other_api_activity);
		LinearLayout linearLayout = (LinearLayout) findViewById(R.id.main_container);
		for (int i = 0; i < linearLayout.getChildCount(); i++) {
			View view = linearLayout.getChildAt(i);
			if (view instanceof Button) {
				view.setOnClickListener(this);
			}
		}

		// 获取有奖分享的intent信息
		if (null != getIntent()) {
			mPrizeIntent = getIntent();
		}
		// 有奖分享处理
		handlePrizeShare();
	}

	@Override
	protected void onResume() {
		super.onResume();
		// 有奖分享处理
		handlePrizeShare();
	}

	@Override
	public void onClick(View v) {
		Context context = v.getContext();
		Animation shake = AnimationUtils.loadAnimation(context, R.anim.shake);
		Class<?> cls = null;
		boolean isAppbar = false;
        int id = v.getId();
        if (id == R.id.main_is_SupportShareToQQ_btn) {
            boolean isurpport = Tencent.isSupportShareToQQ(OtherApiActivity.this);
            Util.showResultDialog(OtherApiActivity.this, "isSupportShareToQQ = " + isurpport, "结果");
        } else if (id == R.id.main_is_SupportPushToQZone_btn) {
            boolean isurpport = Tencent.isSupportPushToQZone(OtherApiActivity.this);
            Util.showResultDialog(OtherApiActivity.this, "isSupportPushToQZone = " + isurpport, "结果");
        } else if (id == R.id.main_is_report_dau_btn) {
            MainActivity.mTencent.reportDAU();
        } else if (id == R.id.get_openid_btn) {
            onClickOpenId();
        } else if (id == R.id.check_login_btn) {
            onClickCheckLogin();
        } else if (id == R.id.main_aio_btn) {
			mChosenIMType = Constants.IM_AIO;
			onClickIm();
			v.startAnimation(shake);
			return;
		} else if (id == R.id.main_audio_chat_btn) {
			mChosenIMType = Constants.IM_AUDIO_CHAT;
			onClickIm();
			v.startAnimation(shake);
			return;
		} else if (id == R.id.main_video_chat_btn) {
			mChosenIMType = Constants.IM_VIDEO_CHAT;
			onClickIm();
			v.startAnimation(shake);
			return;
		} else if (id == R.id.main_mini_app_btn) {
			onClickMiniApp();
			v.startAnimation(shake);
			return;
		} else if (id == R.id.main_getInfo_btn) {
			cls = AccountInfoActivity.class;
		} else if (id == R.id.app_get_unionid) {
			getUnionId();
		} else if (id == R.id.main_sso_btn) {
			if (mTencent.isSupportSSOLogin(OtherApiActivity.this)) {
				Toast.makeText(OtherApiActivity.this, "支持SSO登录", Toast.LENGTH_SHORT).show();
			} else {
				Toast.makeText(OtherApiActivity.this, "不支持SSO登录", Toast.LENGTH_SHORT).show();
			}
			return;
		} else if (id == R.id.main_avatar_btn) {
			cls = AvatarActivity.class;
		} else if (id == R.id.main_emotion_btn) {
			cls = EmotionActivity.class;
		} else if (id == R.id.main_qqgroup_btn) {
			cls = QQGroupActivity.class;
		} else if (id == R.id.universal_action_api) {
			cls = null;
			onClickStartUniversalAction();
		} else if (id == R.id.main_is_qq_installed_btn) {
			Toast.makeText(OtherApiActivity.this, mTencent.isQQInstalled(OtherApiActivity.this) + "", Toast.LENGTH_SHORT).show();
			return;
		}

		Class<?> newCls = onFullFunctionClick(v);
		if (newCls != null) {
			cls = newCls;
		}

		v.startAnimation(shake);
		if (cls != null) {
			Intent intent = new Intent(context, cls);
			if (isAppbar) { //APP内应用吧登录需接收登录结果
				startActivityForResult(intent, Constants.REQUEST_APPBAR);
			} else {
				context.startActivity(intent);
			}
		}
	}

	private Class<?> onFullFunctionClick(View view) {
		int id = view.getId();
		
		
		return null;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		switch (requestCode) {
			case Constants.REQUEST_COMMON_CHANNEL:{
				Tencent.onActivityResultData(requestCode, resultCode, data, commonChannelApiListener);
			}
			break;
			default:
				break;
		}
	}

	@Override
	public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
		super.onRequestPermissionsResult(requestCode, permissions, grantResults);
		PermissionMgr.getInstance().onRequestPermissionsResult(this, requestCode, permissions, grantResults);
	}
	
	private void onClickOpenId() {
		if (MainActivity.ready(OtherApiActivity.this)) {
			UserInfo info = new UserInfo(this,MainActivity.mTencent.getQQToken());
			info.getOpenId(new OtherApiListener("m_me", true,this));
			Util.showProgressDialog(OtherApiActivity.this, null, null);
		}
	}

	private void onClickCheckLogin() {
		if (MainActivity.ready(OtherApiActivity.this)) {
			MainActivity.mTencent.checkLogin(new BaseUIListener(this));
			Util.showProgressDialog(OtherApiActivity.this, null, null);
		}
	}

	/**
	 *
	 * @author zivonchen
	 *
	 */
	private class OtherApiListener extends BaseUIListener {
		private String mScope = "all";
        private Boolean mNeedReAuth = false;
        private Activity mActivity;
    	public OtherApiListener(String scope, boolean needReAuth,
				Activity activity) {
			super(activity);
			this.mScope = scope;
			this.mNeedReAuth = needReAuth;
			this.mActivity = activity;
		}
		@Override
		public void onComplete(Object response) {
			try {
				final Activity activity = OtherApiActivity.this;
				JSONObject json = (JSONObject)response;
				int ret = json.getInt("ret");
				if (ret == 0) {
					Message msg = mHandler.obtainMessage(0, mScope);
					Bundle data = new Bundle();
					data.putString("response", response.toString());
					msg.setData(data);
					mHandler.sendMessage(msg);
				} else if (ret == 100030) {
					if (mNeedReAuth) {
						Runnable r = new Runnable() {
							@Override
                            public void run() {
								MainActivity.mTencent.reAuth(activity,
										mScope, new BaseUIListener(OtherApiActivity.this));
							}
						};
						OtherApiActivity.this.runOnUiThread(r);
					}
				}else {
					Message msg = mHandler.obtainMessage(0,mScope);
					Bundle data = new Bundle();
					data.putString("response", response.toString());
					msg.setData(data);
					mHandler.sendMessage(msg);
				}
			} catch (JSONException e) {
				Util.toastMessage(OtherApiActivity.this,
						"onComplete() JSONException: " + response.toString());
			}
			Util.dismissDialog();
		}
	}



	/**
	 * 1.此处做了优化，点击聊天/语音/视频会去做token的校验
	 * 2.根据情况进行自动登录并且回调
	 * 3.回调后根据不同情况拉起不同业务
	 */
	private void onClickIm() {
		// 调试的时候，使用mTencent.isSessionValid()，因为是当次的
		// 实际使用的时候，使用更加准确的mTencent.checkLogin()
		if (mTencent.isSessionValid()) {
			// 拉起AIO
			// 如果还是失败,意味着token不为空且不过期，但是由于修改密码/被锁定等原因需重新授权，则需重新校验(暂时看看QQ这边是否会有这种情况)
			// jumpIMWithType(mChosenIMType);
			buildUinDialog();
		} else {
			// 根据产品的更改，登录自己完成授权
			Toast.makeText(this, R.string.please_click_login_btn, Toast.LENGTH_LONG).show();
		}
	}

	private void buildUinDialog() {
		mEtTargetUin = new EditText(OtherApiActivity.this);
		AlertDialog.Builder targetUinBuilder = new AlertDialog.Builder(this).setTitle("请输入Target的QQ号")
				.setCancelable(false)
				.setIcon(android.R.drawable.ic_dialog_info)
				.setView(mEtTargetUin)
				.setPositiveButton("Commit", mTargetUinCommitListener);
		targetUinBuilder.show();
	}

	/**
	 * 修改为无需登录授权
	 */
	private void onClickMiniApp() {
		// 拉起小程序/小游戏
		buildMiniAppIdDialog();
	}

	private void buildMiniAppIdDialog() {
		LayoutInflater layoutInflater = LayoutInflater.from(this);
		View miniAppContentView = layoutInflater.inflate(R.layout.dialog_qqminiapp, null);
		mEtTargetMiniAppId = (EditText) miniAppContentView.findViewById(R.id.mini_app_id_edit);
		mEtTargetMiniAppPath = (EditText) miniAppContentView.findViewById(R.id.mini_app_path_edit);
		mEtTargetMiniAppVersion = (EditText) miniAppContentView.findViewById(R.id.mini_app_version_edit);
		// MiniAppId 1108108864 此处和AppId 102060558对应
		mEtTargetMiniAppId.setText(OPEN_CONNECT_DEMO_MINI_APP_ID);
		mEtTargetMiniAppPath.setText(OPEN_CONNECT_DEMO_MINI_APP_PATH);
		mEtTargetMiniAppVersion.setText(MiniApp.MINIAPP_VERSION_RELEASE);
		AlertDialog.Builder targetMiniAppIdBuilder = new AlertDialog.Builder(OtherApiActivity.this).setTitle(R.string.qqconnect_enter_tartget_mini_app_id_tip)
				.setCancelable(false)
				.setIcon(android.R.drawable.ic_dialog_info)
				.setView(miniAppContentView)
				.setPositiveButton("Commit", mTargetMiniAppIdCommitListener);
		targetMiniAppIdBuilder.show();
	}

	/**
	 * 拉起小程序/小游戏
	 * appid能够直接拉取到该应用主体对应的apptype是小程序还是小游戏
	 * 此处暂时无需声明MiniApp的类型
	 */
	private void launchMiniApp() {
		int ret = mTencent.startMiniApp(this, getTargetMiniAppId(), mEtTargetMiniAppPath.getText().toString(),
				mEtTargetMiniAppVersion.getText().toString());
		if (ret != MiniApp.MINIAPP_SUCCESS) {
			// 互联demo针对纯输入出错的地方进行文字提示
			String errorStr = "";
			if (ret == MiniApp.MINIAPP_ID_EMPTY) {
				errorStr = getString(R.string.qqconnect_mini_app_id_empty);
			} else if (ret == MiniApp.MINIAPP_ID_NOT_DIGIT) {
				errorStr = getString(R.string.qqconnect_mini_app_id_not_digit);
			}
			StringBuilder builder = new StringBuilder();
			builder.append("start miniapp failed. error:")
					.append(ret)
					.append(" ")
					.append(errorStr);
			Toast.makeText(getApplicationContext(),
					builder.toString(),
					Toast.LENGTH_LONG).show();
		}
	}

	private DialogInterface.OnClickListener mTargetUinCommitListener = new DialogInterface.OnClickListener() {

		@Override
		public void onClick(DialogInterface dialog, int which) {
			switch (which) {
				case DialogInterface.BUTTON_POSITIVE:
					// 用输入的targetUin
					String editTextContent = mEtTargetUin.getText().toString().trim();
					if (!TextUtils.isEmpty(editTextContent)) {
						saveTargetUin(editTextContent);
					} else {
						Toast.makeText(OtherApiActivity.this, "targetUin为空，请重新设置", Toast.LENGTH_LONG).show();
						return;
					}
					break;
			}
			// 拉起会话
			jumpIMWithType(mChosenIMType);
		}
	};

	private DialogInterface.OnClickListener mTargetMiniAppIdCommitListener = new DialogInterface.OnClickListener() {

		@Override
		public void onClick(DialogInterface dialog, int which) {
			switch (which) {
				case DialogInterface.BUTTON_POSITIVE:
					// 用输入的targetMiniAppId
					String editTextId = mEtTargetMiniAppId.getText().toString().trim();
					if (!TextUtils.isEmpty(editTextId)) {
						saveTargetMiniAppId(editTextId);
					} else {
						Toast.makeText(OtherApiActivity.this, getString(R.string.qqconnect_mini_app_id_empty), Toast.LENGTH_LONG).show();
						return;
					}
					// 校验版本类型
					String editTextVersion = mEtTargetMiniAppVersion.getText().toString();
					if (!MiniApp.OPEN_CONNECT_DEMO_MINI_APP_VERSIONS.contains(editTextVersion)) {
						Toast.makeText(OtherApiActivity.this, getString(R.string.qqconnect_mini_app_version_wrong), Toast.LENGTH_LONG).show();
						return;
					}
					break;
			}
			launchMiniApp();
		}
	};

	private String getTargetMiniAppId() {
		SharedPreferences share = this.getSharedPreferences(SHARE_PREF_NAME, 0);
		return share.getString(KEY_TARGET_QQ_MINIAPP_ID, null);
	}

	private void onClickStartUniversalAction() {
		// 接入方对接时确认是否需要登陆态，是则使用下面方法提前判断登陆态，避免进入手Q后提示无登陆态
		if(!mTencent.isSessionValid()){
			Toast.makeText(this, R.string.please_click_login_btn, Toast.LENGTH_LONG).show();
			return;
		}
		// 接入方对接时确认功能的最低手Q版本，使用下面代码提前判断
		if (!mTencent.isQQInstalled(this, "8.8.80")){
			Toast.makeText(this, R.string.upgrade_qq, Toast.LENGTH_LONG).show();
			return;
		}
		Bundle params = new Bundle();
		// 接入方对接时需要提前确认 src_id（该id需要向互联后台申请）
		params.putInt(Constants.PARAM_SRC_ID, 3002);
		JSONObject jsonObject = new JSONObject();
		try {
			// 此处的参数列表对应手Q设置在线状态"追剧中"
			jsonObject.put("cid", "mzc00200p29gosv");
			jsonObject.put("title", "斗破苍穹 第4季");
			jsonObject.put("url","www.qq.com");
		} catch (JSONException e) {
			e.printStackTrace();
		}
		params.putString(Constants.PARAM_EXT_DATA, jsonObject.toString());
		mTencent.callCommonChannelApi(OtherApiActivity.this, params, commonChannelApiListener);
	}

	private void getUnionId() {
		if (mTencent != null && mTencent.isSessionValid()) {
			IUiListener listener = new DefaultUiListener() {
				@Override
				public void onError(UiError e) {
					Toast.makeText(OtherApiActivity.this,"onError",Toast.LENGTH_LONG).show();
				}

				@Override
				public void onComplete(final Object response) {
					if(response != null){
						JSONObject jsonObject = (JSONObject)response;
						try {
							String unionid = jsonObject.getString("unionid");
							Util.showResultDialog(OtherApiActivity.this, "unionid:\n"+unionid, "onComplete");
							Util.dismissDialog();
						}catch (Exception e){
							Toast.makeText(OtherApiActivity.this,"no unionid",Toast.LENGTH_LONG).show();
						}
					}else {
						Toast.makeText(OtherApiActivity.this,"no unionid",Toast.LENGTH_LONG).show();
					}
				}

				@Override
				public void onCancel() {
					Toast.makeText(OtherApiActivity.this,"onCancel",Toast.LENGTH_LONG).show();
				}
			};
			UnionInfo unionInfo = new UnionInfo(this, mTencent.getQQToken());
			unionInfo.getUnionId(listener);
		} else {
			Toast.makeText(this,"please login frist!",Toast.LENGTH_LONG).show();
		}
	}

	/**
	 * 根据传参拉起不同的IM业务
	 *
	 * @param type
	 */
	private void jumpIMWithType(int type) {
		int ret = IM.IM_UNKNOWN_TYPE;
		if (type == Constants.IM_AIO) {
			ret = mTencent.startIMAio(this, getTargetUin(), getPackageName());
		} else if (type == Constants.IM_AUDIO_CHAT) {
			ret = mTencent.startIMAudio(this, getTargetUin(), getPackageName());
		} else if (type == Constants.IM_VIDEO_CHAT) {
			ret = mTencent.startIMVideo(this, getTargetUin(), getPackageName());
		}
		if (ret != IM.IM_SUCCESS) {
			Toast.makeText(getApplicationContext(),
					"start IM conversation failed. error:" + ret,
					Toast.LENGTH_LONG).show();
		}
	}


	/**
	 * 设置成持久化，后续可以不用每次弹出
	 * @param targetUin
	 */
	protected void saveTargetUin(String targetUin) {
		if (targetUin != null) {
			SharedPreferences share = this.getSharedPreferences(SHARE_PREF_NAME, 0);
			SharedPreferences.Editor editor = share.edit();
			editor.putString(KEY_TARGET_QQ_UIN, targetUin);
			editor.commit();
		}
	}

	private String getTargetUin() {
		SharedPreferences share = this.getSharedPreferences(SHARE_PREF_NAME, 0);
		return share.getString(KEY_TARGET_QQ_UIN, null);
	}

	/**
	 * 可以保存下来，开发者可以参考demo的保存方式
	 * @param miniAppId
	 */
	protected void saveTargetMiniAppId(String miniAppId) {
		if (miniAppId != null) {
			SharedPreferences share = this.getSharedPreferences(SHARE_PREF_NAME, 0);
			SharedPreferences.Editor editor = share.edit();
			editor.putString(KEY_TARGET_QQ_MINIAPP_ID, miniAppId);
			editor.commit();
		}
	}

	/**
	 * 有奖分享处理，未接入有奖分享可以不考虑
	 */
	private void handlePrizeShare() {
		
	}

	
}
