package com.tencent.sample.activitys;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.tencent.connect.UnionInfo;
import com.tencent.connect.UserInfo;
import com.tencent.connect.auth.AuthAgent;
import com.tencent.connect.common.Constants;
import com.tencent.open.apireq.BaseResp;
import com.tencent.open.apireq.IApiCallback;
import com.tencent.open.im.IM;
import com.tencent.open.log.SLog;
import com.tencent.open.miniapp.MiniApp;
import com.tencent.sample.AppConstants;
import com.tencent.sample.PermissionMgr;
import com.tencent.sample.R;
import com.tencent.sample.Util;
import com.tencent.sample.util.ServerSideUserInfoTestUtils;
import com.tencent.tauth.DefaultUiListener;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import static com.tencent.connect.common.Constants.KEY_ADD_LOGIN_ACCOUNT;
import static com.tencent.connect.common.Constants.KEY_ENABLE_SHOW_DOWNLOAD_URL;
import static com.tencent.connect.common.Constants.KEY_PROXY_APPID;
import static com.tencent.connect.common.Constants.KEY_QRCODE;
import static com.tencent.connect.common.Constants.KEY_RESTORE_LANDSCAPE;
import static com.tencent.connect.common.Constants.KEY_SCOPE;

public class MainActivity extends Activity {
    private final String tag = "MainActivity_" + hashCode();
    public static String mAppid = AppConstants.APP_ID;

	private static final String SP_NAME_MAIN_ACT = "sp_main_act";

	private static MainActivity sCurMainAct = null;

	private Button mNewLoginButton;
	private Button mServerSideLoginBtn;
	private TextView mUserInfo;
	private ImageView mUserLogo;

	public static Tencent mTencent;
	private CheckBox mCheckPermissionGranted;
	protected CheckBox mQrCk;
	protected CheckBox mCheckForceQr;
	protected CheckBox mOEMLogin;
	protected CheckBox mShowWebDownloadUi;

	private SharedPreferences mSp;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		Log.d(tag, "-->onCreate--" + hashCode());
		setContentView(R.layout.activity_main_new);
		mSp = getSharedPreferences(SP_NAME_MAIN_ACT, MODE_PRIVATE);
		initViews();

		mTencent = Tencent.createInstance(mAppid, MainActivity.this, AppConstants.APP_AUTHORITIES);
		if (mTencent == null) {
			SLog.e(tag, "Tencent instance create fail!");
			finish();
		}

		autoLogin();



		Map<String, String> params = Tencent.parseMiniParameters(getIntent());
		if (!params.isEmpty()) {
			Iterator<Map.Entry<String, String>> iter = params.entrySet().iterator();

			StringBuffer sBuf = new StringBuffer();
			while (iter.hasNext()) {
				Map.Entry<String, String> entry = iter.next();
				sBuf.append(entry.getKey() + "=" + entry.getValue()).append(" ");
			}

			Toast.makeText(this, sBuf.toString(), Toast.LENGTH_LONG).show();
		}

		PermissionMgr.getInstance().requestPermissions(this);
		sCurMainAct = this;
	}

	private void autoLogin() {
		if (mTencent == null || !mCheckPermissionGranted.isChecked()) {
			return;
		}
		JSONObject jsonObject = mTencent.loadSession(AppConstants.APP_ID);
		Log.i(tag, "initLocalData: " + jsonObject);
		if (jsonObject != null) {
			initOpenidAndToken(jsonObject);

			if (TextUtils.isEmpty(mTencent.getAccessToken())) {
				mTencent.initSessionCache(mTencent.loadSession(AppConstants.APP_ID));
			}
		}
		if (MainActivity.ready(MainActivity.this)) {
			mTencent.checkLogin(new DefaultUiListener() {
				@Override
				public void onComplete(Object response) {
					Log.i(tag, "checkTokenValid onComplete: " + response);
					JSONObject jsonResp = (JSONObject) response;
					if (jsonResp.optInt("ret", -1) == 0) {
						JSONObject jsonObject = mTencent.loadSession(AppConstants.APP_ID);
						mTencent.initSessionCache(jsonObject);
						if (jsonObject == null) {
							Util.showResultDialog(MainActivity.this, "jsonObject is null", "登录失败");
						}
					} else {
						mTencent.logout(MainActivity.this);
						Util.showResultDialog(MainActivity.this, "token过期，请调用登录接口拉起手Q授权登录", "登录失败");
					}
					updateUserInfo();
					updateLoginButton();
				}

				@Override
				public void onError(UiError e) {
					Log.e(tag, "checkTokenValid onError: " + e);
					if (e != null && !TextUtils.isEmpty(e.errorMessage)) {
						Util.showResultDialog(MainActivity.this, e.errorMessage, "登录失败");
					} else {
						Util.showResultDialog(MainActivity.this, "token过期，请调用登录接口拉起手Q授权登录", "登录失败");
					}
					if (e != null && e.errorCode != Constants.ERROR_NETWORK_UNAVAILABLE) {
						mTencent.logout(MainActivity.this);
						updateUserInfo();
						updateLoginButton();
					}
				}
			});
		}
	}

	@Override
	public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
		super.onRequestPermissionsResult(requestCode, permissions, grantResults);
		PermissionMgr.getInstance().onRequestPermissionsResult(this, requestCode, permissions, grantResults);
	}

	@Override
	protected void onDestroy() {
		Log.d(tag, "-->onDestroy");
		super.onDestroy();
		if (sCurMainAct == this) {
			sCurMainAct = null;
		}
	}

	private void initViews() {
		mNewLoginButton = findViewById(R.id.new_login_btn);
		mServerSideLoginBtn =findViewById(R.id.server_side_login_btn);
		mServerSideLoginBtn.setTextColor(Color.BLUE);
		mServerSideLoginBtn.setText("Server-Side登录");

		mCheckPermissionGranted = findViewById(R.id.check_permission_granted);
		boolean isChecked = mSp.getBoolean("isPermissionGranted", false);
		Tencent.setIsPermissionGranted(isChecked);
		mCheckPermissionGranted.setChecked(isChecked);
		mCheckPermissionGranted.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				Tencent.setIsPermissionGranted(isChecked);
				mSp.edit().putBoolean("isPermissionGranted", isChecked).commit();
			}
		});

		mQrCk = findViewById(R.id.ck_qr);
		mCheckForceQr = findViewById(R.id.check_force_qr);
		mCheckForceQr.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
				if (compoundButton.getId() == R.id.check_force_qr) {
					mQrCk.setChecked(b);
				}
			}
		});
		mOEMLogin = findViewById(R.id.check_oem_login);
		mShowWebDownloadUi = findViewById(R.id.show_web_download_ui);

		LinearLayout linearLayout = findViewById(R.id.main_container);
		OnClickListener listener = new NewClickListener();
		for (int i = 0; i < linearLayout.getChildCount(); i++) {
			View view = linearLayout.getChildAt(i);
			if (view instanceof Button) {
				view.setOnClickListener(listener);
			}
		}
		mNewLoginButton.setOnClickListener(listener);
		mServerSideLoginBtn.setOnClickListener(listener);
		mQrCk.setOnClickListener(listener);
		mUserInfo = findViewById(R.id.user_nickname);
		mUserLogo = findViewById(R.id.user_logo);
		updateLoginButton();
	}

	protected void updateLoginButton() {
		final MainActivity mainAct = sCurMainAct != null ? sCurMainAct: MainActivity.this;
		boolean valid = mTencent != null && mTencent.isSessionValid();
		Log.d(tag, "updateLoginButton: valid: " + valid);
		if (valid) {
			mainAct.mNewLoginButton.setTextColor(Color.RED);
			mainAct.mNewLoginButton.setText("退出帐号");
		} else {
			mainAct.mNewLoginButton.setTextColor(Color.BLUE);
			mainAct.mNewLoginButton.setText("登录");
		}
	}

	protected void updateUserInfo() {
		if (mTencent != null && mTencent.isSessionValid()) {
			IUiListener listener = new DefaultUiListener() {

				@Override
				public void onError(UiError e) {

				}

				@Override
				public void onComplete(final Object response) {
					final MainActivity mainAct = sCurMainAct != null ? sCurMainAct: MainActivity.this;

					Message msg = new Message();
					msg.obj = response;
					msg.what = 0;
					mainAct.mHandler.sendMessage(msg);
					new Thread(){

						@Override
						public void run() {
							JSONObject json = (JSONObject)response;
							Log.d(tag, "updateUserInfo: " + response);
							if(json.has("figureurl")){
								Bitmap bitmap = null;
								try {
									bitmap = Util.getbitmap(json.getString("figureurl_qq_2"));
								} catch (JSONException e) {
									Log.e(tag, "Util.getBitmap() jsonException : " + e.getMessage());
								}
								Message msg = new Message();
								msg.obj = bitmap;
								msg.what = 1;
								mainAct.mHandler.sendMessage(msg);
							}
						}

					}.start();
				}

				@Override
				public void onCancel() {

				}
			};
			UserInfo info = new UserInfo(this, mTencent.getQQToken());
			info.getUserInfo(listener);

		} else {
			mUserInfo.setText("");
			mUserInfo.setVisibility(android.view.View.GONE);
			mUserLogo.setVisibility(android.view.View.GONE);
		}
	}

	Handler mHandler = new Handler(Looper.getMainLooper()) {

		@Override
		public void handleMessage(Message msg) {
			if (msg.what == 0) {
				JSONObject response = (JSONObject) msg.obj;
				if (response.has("nickname")) {
					try {
						mUserInfo.setVisibility(android.view.View.VISIBLE);
						mUserInfo.setText(response.getString("nickname"));
					} catch (JSONException e) {
						e.printStackTrace();
					}
				}
			} else if(msg.what == 1){
				Bitmap bitmap = (Bitmap)msg.obj;
				mUserLogo.setImageBitmap(bitmap);
				mUserLogo.setVisibility(android.view.View.VISIBLE);
			}
		}

	};

	protected void onClickLogin() {
		if (!mTencent.isSessionValid()) {
			// 强制扫码登录
		    this.getIntent().putExtra(AuthAgent.KEY_FORCE_QR_LOGIN, mCheckForceQr.isChecked());

		    if (mOEMLogin.isChecked()) {
				mTencent.loginWithOEM(this, "all", loginListener, mQrCk.isChecked(), "10000144","10000144","xxxx");
			} else {
				HashMap<String, Object> params = new HashMap<String, Object>();
				if (getRequestedOrientation() == ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE) {
					params.put(KEY_RESTORE_LANDSCAPE, true);
				}

				
				// 指定添加帐号
				Editable addLoginAccount = ((EditText)findViewById(R.id.add_login_account)).getText();
				if (!TextUtils.isEmpty(addLoginAccount)) {
					params.put(KEY_ADD_LOGIN_ACCOUNT, addLoginAccount.toString());
				}

				params.put(KEY_SCOPE, "all");
				params.put(KEY_QRCODE, mQrCk.isChecked());
				params.put(KEY_ENABLE_SHOW_DOWNLOAD_URL, mShowWebDownloadUi.isChecked());

				CheckBox checkBox = findViewById(R.id.check_auth_new_callback);
				int callbackType = checkBox.isChecked() ? Constants.CALLBACK_TYPE_START_ACT : Constants.CALLBACK_TYPE_SET_RESULT;
				params.put(Constants.KEY_CALLBACK_TYPE, callbackType);
				mTencent.login(this, loginListener, params);
			}
			Log.d("SDKQQAgentPref", "FirstLaunch_SDK:" + SystemClock.elapsedRealtime());
		} else {
		    mTencent.logout(this);
			updateUserInfo();
			updateLoginButton();
		}
	}

    private void onClickServerSideLogin() {
		if (mTencent.isSessionValid()) {
			mTencent.logout(this);
			updateUserInfo();
			updateLoginButton();
		}
		// 强制扫码登录
		this.getIntent().putExtra(AuthAgent.KEY_FORCE_QR_LOGIN, mCheckForceQr.isChecked());
		mTencent.loginServerSide(this, "all", serverSideLoginListener, mQrCk.isChecked());
    }

	private void gotoAuthPage() {
		mTencent.startAuthManagePage(MainActivity.this, new IApiCallback() {
			@Override
			public void onResp(BaseResp baseResp) {
				if (baseResp.isSuccess()) {
					// 跳转成功
					return;
				}
				String showMsg;
				switch (baseResp.getCode()) {
					case BaseResp.CODE_QQ_NOT_INSTALLED:
						showMsg = getString(R.string.qq_not_install);
						break;
					case BaseResp.CODE_UNSUPPORTED_BRANCH:
						showMsg = getString(R.string.qq_branch_not_support);
						break;
					case BaseResp.CODE_QQ_LOW_VERSION:
						showMsg = getString(R.string.upgrade_qq);
						break;
					case BaseResp.CODE_NOT_LOGIN:
						showMsg = getString(R.string.need_login);
						break;
					default:
						showMsg = baseResp.toString();
						break;
				}
				Toast.makeText(MainActivity.this, showMsg, Toast.LENGTH_SHORT).show();
			}
		});
	}

	public static boolean ready(Context context) {
		if (mTencent == null) {
			return false;
		}
		boolean ready = mTencent.isSessionValid() && mTencent.getQQToken().getOpenId() != null;
		if (!ready) {
            Toast.makeText(context, "login and get openId first, please!", Toast.LENGTH_SHORT).show();
        }
		return ready;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
	    Log.d(tag, "-->onActivityResult --" + hashCode() +" requestCode= " + requestCode  + " resultCode=" + resultCode);
        if (requestCode == Constants.REQUEST_LOGIN) {
            Tencent.onActivityResultData(requestCode, resultCode, data, loginListener);
        }
	    super.onActivityResult(requestCode, resultCode, data);
	}

	public static void initOpenidAndToken(JSONObject jsonObject) {
        try {
            String token = jsonObject.getString(Constants.PARAM_ACCESS_TOKEN);
            String expires = jsonObject.getString(Constants.PARAM_EXPIRES_IN);
            String openId = jsonObject.getString(Constants.PARAM_OPEN_ID);
            if (!TextUtils.isEmpty(token) && !TextUtils.isEmpty(expires)
                    && !TextUtils.isEmpty(openId)) {
                mTencent.setAccessToken(token, expires);
                mTencent.setOpenId(openId);
            }
        } catch(Exception e) {
        }
    }

	IUiListener loginListener = new BaseUiListener() {
        @Override
        protected void doComplete(JSONObject values) {
        	Log.d("SDKQQAgentPref", "AuthorSwitch_SDK:" + SystemClock.elapsedRealtime());
            initOpenidAndToken(values);
            updateUserInfo();
            updateLoginButton();
        }
    };

	IUiListener serverSideLoginListener = new BaseUiListener() {
        @Override
		protected void doComplete(JSONObject values) {
			Log.d(tag, "serverSideLogin doComplete:" + values);
			String authCode = "";

			try {
				authCode = values.getString("access_token");
				Log.d(tag, "parseAuthResultData json: " + values);
				ServerSideUserInfoTestUtils.serverGetUserInfo(MainActivity.this, mHandler, authCode);
			} catch (Exception e) {
				Log.e(tag, "serverSideLoginListener doComplete error: ", e);
			}
		}
    };

	public class BaseUiListener extends DefaultUiListener {

		@Override
		public void onComplete(Object response) {
            if (null == response) {
                Util.showResultDialog(MainActivity.this, "返回为空", "登录失败");
                return;
            }
            JSONObject jsonResponse = (JSONObject) response;
            if (jsonResponse.length() == 0) {
                Util.showResultDialog(MainActivity.this, "返回为空", "登录失败");
                return;
            }
			Util.showResultDialog(MainActivity.this, response.toString(), "登录成功");
			doComplete((JSONObject)response);
		}

		protected void doComplete(JSONObject values) {

		}

		@Override
		public void onError(UiError e) {
			Util.toastMessage(MainActivity.this, "onError: " + e.errorDetail);
			Util.dismissDialog();
		}

		@Override
		public void onCancel() {
			Util.toastMessage(MainActivity.this, "onCancel: ");
			Util.dismissDialog();
		}
	}

	class NewClickListener implements OnClickListener {
		@Override
		public void onClick(View v) {
			Context context = v.getContext();
			Animation shake = AnimationUtils.loadAnimation(context, R.anim.shake);
			Class<?> cls = null;
            int id = v.getId();
            if (id == R.id.new_login_btn) {
                onClickLogin();
                v.startAnimation(shake);
                return;
            } else if (id == R.id.ck_qr) {
                if (mQrCk.isChecked()) {
                    Toast.makeText(MainActivity.this, "没有装手q时支持二维码登录，一般用于电视等设备", Toast.LENGTH_LONG).show();
                }
                return;
            } else if (id == R.id.server_side_login_btn) {
                onClickServerSideLogin();
                v.startAnimation(shake);
                return;
            } else if (id == R.id.main_qqShare_btn) {
                cls = QQShareActivity.class;
            } else if (id == R.id.main_qzoneShare_btn) {
                cls = QZoneShareActivity.class;
            } else if (id == R.id.check_token_valid) {
                if (TextUtils.isEmpty(mTencent.getAccessToken())) {
                    mTencent.initSessionCache(mTencent.loadSession(mAppid));
                }
                if (MainActivity.ready(MainActivity.this)) {
                    mTencent.checkLogin(new DefaultUiListener() {
                        @Override
                        public void onComplete(Object response) {
                            JSONObject jsonResp = (JSONObject) response;
                            if (jsonResp.optInt("ret", -1) == 0) {
                                JSONObject jsonObject = mTencent.loadSession(mAppid);
                                mTencent.initSessionCache(jsonObject);
                                if (jsonObject == null) {
                                    Util.showResultDialog(MainActivity.this, "jsonObject is null", "登录失败");
                                } else {
                                    Util.showResultDialog(MainActivity.this, jsonObject.toString(), "登录成功");
                                }
                            } else {
                                Util.showResultDialog(MainActivity.this, "token过期，请调用登录接口拉起手Q授权登录", "登录失败");
                                mTencent.logout(MainActivity.this);
                            }
                            updateUserInfo();
                            updateLoginButton();
                        }

                        @Override
                        public void onError(UiError e) {
                            if (e != null && !TextUtils.isEmpty(e.errorMessage)) {
                                Util.showResultDialog(MainActivity.this, e.errorMessage, "登录失败");
                            } else {
                                Util.showResultDialog(MainActivity.this, "token过期，请调用登录接口拉起手Q授权登录", "登录失败");
                            }
                        }

                        @Override
                        public void onCancel() {
                            Util.toastMessage(MainActivity.this, "onCancel");
                        }
                    });
                }
            } else if (id == R.id.main_others_btn) {
                cls = OtherApiActivity.class;
            } else if (id == R.id.clear_qq_app_info_cache_btn) {
				cls = null;
				Tencent.resetTargetAppInfoCache();
			} else if (id == R.id.open_auth_page_btn) {
				gotoAuthPage();
			}
			v.startAnimation(shake);
			if (cls != null) {
				Intent intent = new Intent(context, cls);
				context.startActivity(intent);
			}
		}
	}
}
