package com.tencent.sample;

import android.util.Log;

import com.tencent.open.log.TraceLevel;
import com.tencent.open.log.Tracer;

public class SdkTracer extends Tracer {

    private static final Boolean NEED_LOGCAT = false;

    @Override
    protected void doTrace(int level, Thread thread, long time, String tag, String msg, Throwable tr) {
        switch (level) {
            case TraceLevel.VERBOSE:
                if (NEED_LOGCAT) {
                    Log.v(tag, msg, tr);
                }
                LogToFile.v(tag, msg);
                break;
            case TraceLevel.DEBUG:
                if (NEED_LOGCAT) {
                    Log.d(tag, msg, tr);
                }
                LogToFile.d(tag, msg);
                break;
            case TraceLevel.INFO:
                if (NEED_LOGCAT) {
                    Log.i(tag, msg, tr);
                }
                LogToFile.i(tag, msg);
                break;
            case TraceLevel.WARN:
                if (NEED_LOGCAT) {
                    Log.w(tag, msg, tr);
                }
                LogToFile.w(tag, msg);
                break;
            case TraceLevel.ERROR:
            default:
                if (NEED_LOGCAT) {
                    Log.e(tag, msg, tr);
                }
                LogToFile.e(tag, msg);
                break;
        }
    }
}
