//                                
// Copyright 2011 ESCOZ Inc  - http://escoz.com
// 
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this 
// file except in compliance with the License. You may obtain a copy of the License at 
// 
// http://www.apache.org/licenses/LICENSE-2.0 
// 
// Unless required by applicable law or agreed to in writing, software distributed under
// the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF 
// ANY KIND, either express or implied. See the License for the specific language governing
// permissions and limitations under the License.
//
#import "QuickDialogTableView.h"
#import <Foundation/Foundation.h>
#import "UIKit/UIKit.h"

@class QRootElement;
@class QElement;

@interface QSection : NSObject {

    NSString *_key;
    NSString *_bind;

    CGRect _entryPosition;

@private
    UIView *_headerView;
    UIView *_footerView;
}

@property (nonatomic, copy) NSString *key;
@property (nonatomic, copy) NSString *bind;

@property (nonatomic, copy) NSString *title;
@property (nonatomic, copy) NSString *footer;
@property (nonatomic, strong) NSMutableArray * elements;
@property (nonatomic, strong) NSMutableArray * beforeTemplateElements;
@property (nonatomic, strong) NSMutableArray * afterTemplateElements;

@property (nonatomic, weak) QRootElement *rootElement;

@property (nonatomic, assign, readonly) BOOL needsEditing;

@property (nonatomic, strong) UIView *headerView;
@property (nonatomic, copy) NSString *headerImage;

@property (nonatomic, strong) UIView *footerView;
@property (nonatomic, copy) NSString *footerImage;

@property (nonatomic) CGRect entryPosition;
@property (nonatomic, copy) NSDictionary *elementTemplate;

@property (nonatomic, assign) BOOL hidden;
@property (nonatomic, assign, readonly) NSUInteger visibleIndex;

@property (nonatomic, assign) BOOL canDeleteRows;
@property (nonatomic, strong) id object;


- (QSection *)initWithTitle:(NSString *)string;

- (void)addElement:(QElement *)element;
- (void)insertElement:(QElement *)element atIndex:(NSUInteger)index;
- (NSUInteger)indexOfElement:(QElement *)element;

- (QElement *)getVisibleElementForIndex:(NSInteger)index;
- (NSInteger)visibleNumberOfElements;
- (NSUInteger)getVisibleIndexForElement:(QElement*)element;

- (void)bindToObject:(id)data;
- (void)fetchValueIntoObject:(id)obj;
- (void)fetchValueUsingBindingsIntoObject:(id)data;
@end
