//                                
// Copyright 2011 ESCOZ Inc  - http://escoz.com
// 
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this 
// file except in compliance with the License. You may obtain a copy of the License at 
// 
// http://www.apache.org/licenses/LICENSE-2.0 
// 
// Unless required by applicable law or agreed to in writing, software distributed under
// the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF 
// ANY KIND, either express or implied. See the License for the specific language governing
// permissions and limitations under the License.
//
#import "QLabelElement.h"

@protocol QuickDialogEntryElementDelegate;

@interface QEntryElement : QLabelElement <UITextInputTraits>

@property (nonatomic, copy) NSString *textValue;
@property (nonatomic, copy) NSString *placeholder;
@property (nonatomic, copy) NSString *prefix;
@property (nonatomic, copy) NSString *suffix;
@property (nonatomic, assign) BOOL hiddenToolbar;

@property (nonatomic, unsafe_unretained) id<QuickDialogEntryElementDelegate> delegate;

@property (nonatomic, assign) UITextAutocapitalizationType autocapitalizationType; // default is UITextAutocapitalizationTypeSentences
@property (nonatomic, assign) UITextAutocorrectionType autocorrectionType;         // default is UITextAutocorrectionTypeDefault
@property (nonatomic, assign) UIKeyboardType keyboardType;                         // default is UIKeyboardTypeDefault
@property (nonatomic, assign) UIKeyboardAppearance keyboardAppearance;             // default is UIKeyboardAppearanceDefault
@property (nonatomic, assign) UIReturnKeyType returnKeyType;                       // default is UIReturnKeyDefault (See note under UIReturnKeyType enum)
@property (nonatomic, assign) BOOL enablesReturnKeyAutomatically;                  // default is NO (when YES, will automatically disable return key when text widget has zero-length contents, and will automatically enable when text widget has non-zero-length contents)
@property (nonatomic, assign, getter=isSecureTextEntry) BOOL secureTextEntry;       // default is NO
@property (nonatomic, assign) BOOL clearsOnBeginEditing;                   // default is NO

@property (nonatomic, copy) NSString *customDateFormat;

- (QEntryElement *)init;
- (QEntryElement *)initWithTitle:(NSString *)string Value:(NSString *)param Placeholder:(NSString *)string1;

- (BOOL)canTakeFocus;

- (void) fieldDidEndEditing;

@end
