//                                
// Copyright 2011 ESCOZ Inc  - http://escoz.com
// 
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this 
// file except in compliance with the License. You may obtain a copy of the License at 
// 
// http://www.apache.org/licenses/LICENSE-2.0 
// 
// Unless required by applicable law or agreed to in writing, software distributed under
// the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF 
// ANY KIND, either express or implied. See the License for the specific language governing
// permissions and limitations under the License.
//

#import "QTableViewCell.h"

@class QSection;
@class QuickDialogTableView;
@class QuickDialogController;

@interface QElement : NSObject {

@protected
    NSString *_key;
    NSString *_bind;
	
	CGFloat _height;
    BOOL _hidden;

    void (^_onSelected)(void);
    NSString * _controllerAction;
}

@property (nonatomic, assign, getter=isEnabled) BOOL enabled;

@property (nonatomic, copy) void (^onSelected)(void);
@property (nonatomic, copy) NSString *controllerAction;
@property (nonatomic, copy) NSString *controllerAccessoryAction;

@property (nonatomic, assign) CGFloat height;
@property (nonatomic, assign) BOOL    hidden;
@property (nonatomic, assign, readonly) NSUInteger visibleIndex;

@property (nonatomic, weak) QSection *parentSection;

@property (nonatomic, copy) NSString *key;
@property (nonatomic, strong) id object;
@property (nonatomic, copy) NSString *bind;

@property (nonatomic, assign) QLabelingPolicy labelingPolicy;

- (QElement *)initWithKey:(NSString *)key;

- (NSIndexPath*) getIndexPath;

- (UITableViewCell *)getCellForTableView:(QuickDialogTableView *)tableView controller:(QuickDialogController *)controller;

-(QTableViewCell *)getOrCreateEmptyCell:(QuickDialogTableView *)tableView;

- (void)handleElementSelected:(QuickDialogController *)controller;

- (void)selectedAccessory:(QuickDialogTableView *)tableView controller:(QuickDialogController *)controller indexPath:(NSIndexPath *)indexPath;


- (void)selected:(QuickDialogTableView *)tableView controller:(QuickDialogController *)controller indexPath:(NSIndexPath *)indexPath;

- (CGFloat)getRowHeightForTableView:(QuickDialogTableView *)tableView;

- (void)fetchValueIntoObject:(id)obj;

- (void)bindToObject:(id)obj;

- (void)fetchValueUsingBindingsIntoObject:(id)object;


@end
