//                                
// Copyright 2011 ESCOZ Inc  - http://escoz.com
// 
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this 
// file except in compliance with the License. You may obtain a copy of the License at 
// 
// http://www.apache.org/licenses/LICENSE-2.0 
// 
// Unless required by applicable law or agreed to in writing, software distributed under
// the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF 
// ANY KIND, either express or implied. See the License for the specific language governing
// permissions and limitations under the License.
//

#import "QuickDialogTableView.h"
#import "QEntryElement.h"

@interface QDateTimeInlineElement : QEntryElement {
    NSDate * _dateValue;
@private
    UIDatePickerMode _mode;
    NSInteger _minuteInterval;
    BOOL _centerLabel;
}

@property (nonatomic, strong) NSDate *dateValue;
@property (nonatomic, strong) NSNumber *ticksValue;

@property (nonatomic, assign) UIDatePickerMode mode;

@property (nonatomic, assign) NSInteger minuteInterval;

@property (nonatomic, assign) BOOL centerLabel;

@property (nonatomic, strong) NSDate *maximumDate;

@property (nonatomic, strong) NSDate *minimumDate;


- (QDateTimeInlineElement *)initWithDate:(NSDate *)date andMode:(UIDatePickerMode)mode;

- (QDateTimeInlineElement *)initWithTitle:(NSString *)string date:(NSDate *)date andMode:(UIDatePickerMode)mode;

@end
