// created by Iain Stubbs but based on the QEntryElement.h
//
// Copyright 2011 ESCOZ Inc  - http://escoz.com
// 
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this 
// file except in compliance with the License. You may obtain a copy of the License at 
// 
// http://www.apache.org/licenses/LICENSE-2.0 
// 
// Unless required by applicable law or agreed to in writing, software distributed under
// the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF 
// ANY KIND, either express or implied. See the License for the specific language governing
// permissions and limitations under the License.
//
#import "QLabelElement.h"
#import "DOAutocompleteTextField.h"

#import "QEntryElement.h"


@interface QAutoEntryElement : QEntryElement <UITextInputTraits, DOAutocompleteTextFieldDelegate>

@property (nonatomic, copy) NSString *textValue;
@property (nonatomic, copy) NSString *placeholder;
@property (nonatomic, copy) NSArray *autoCompleteValues;
@property (nonatomic, strong) UIColor *autoCompleteColor;
@property (nonatomic, assign) BOOL hiddenToolbar;
@property (nonatomic, copy) NSString *lastAutoComplete;

@property (nonatomic, unsafe_unretained) id<QuickDialogEntryElementDelegate> delegate;

@property (nonatomic, assign) UITextAutocapitalizationType autocapitalizationType; // default is UITextAutocapitalizationTypeSentences
@property (nonatomic, assign) UITextAutocorrectionType autocorrectionType;         // default is UITextAutocorrectionTypeDefault
@property (nonatomic, assign) UIKeyboardType keyboardType;                         // default is UIKeyboardTypeDefault
@property (nonatomic, assign) UIKeyboardAppearance keyboardAppearance;             // default is UIKeyboardAppearanceDefault
@property (nonatomic, assign) UIReturnKeyType returnKeyType;                       // default is UIReturnKeyDefault (See note under UIReturnKeyType enum)
@property (nonatomic, assign) BOOL enablesReturnKeyAutomatically;                  // default is NO (when YES, will automatically disable return key when text widget has zero-length contents, and will automatically enable when text widget has non-zero-length contents)
@property (nonatomic, assign, getter=isSecureTextEntry) BOOL secureTextEntry;       // default is NO

- (QAutoEntryElement *)init;

- (QAutoEntryElement *)initWithTitle:(NSString *)string value:(NSString *)param placeholder:(NSString *)string1;

@end
