//
//  CheckAuthDetail.m
//  sdkDemo
//
//  Created by Zhe Wang on 2021/1/24.
//  Copyright © 2021 qqconnect. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CheckAuthDetailViewController.h"
#import "SDKCall.h"
#import <TencentOpenAPI/TencentOAuth.h>
#import <TencentOpenAPI/QQApiInterfaceObject.h>
#import <TencentOpenAPI/QQApiInterface.h>

@implementation CheckAuthDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];

    self.navigationItem.title = @"修改授权详情";
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"完成" style:UIBarButtonItemStylePlain target:self action:@selector(jumpToQQAuthDetail:)];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(getUserInfoSuccessedForAuth:) name:kGetUserInfoResponse object:nil];
    

}

- (BOOL)checkStatusValid {
    if (![[TencentOAuth sharedInstance] getUserInfo]){
        return NO;
    } 
    return YES;
}

- (void)getUserInfoSuccessedForAuth:(NSNotification *)notification{
    
    NSDictionary *userInfo = notification.userInfo;
    APIResponse *response = userInfo[kResponse];
    NSDictionary *message = response.jsonResponse;
    
    if (!message[@"nickname"])
    {
        UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"检查结果" message:@"当前未登录，请先登录！" delegate:nil cancelButtonTitle:@"好的" otherButtonTitles:nil];
        [alertView show];
        return;
    }
    else {
    
    QQApiAuthObject *checkAuth = [QQApiAuthObject new];
    
    SendMessageToQQReq* req = [SendMessageToQQReq reqWithContent:checkAuth];
    QQApiSendResultCode sent = [QQApiInterface sendMessageToQQAuthWithReq:req];
        [self handleSendResult:sent];
        
    }
    
}

- (void)jumpToQQAuthDetail:(id)sender {
    
    if (![self checkStatusValid]){
        
        UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"检查结果" message:@"当前未登录，请先登录！" delegate:nil cancelButtonTitle:@"好的" otherButtonTitles:nil];
        [alertView show];
        return;
    }
    
}

- (void)handleSendResult:(QQApiSendResultCode)sendResult {
    switch (sendResult)
    {
        case EQQAPIAPPNOTREGISTED:
        {
            UIAlertView *msgbox = [[UIAlertView alloc] initWithTitle:@"Error" message:@"App未注册" delegate:nil cancelButtonTitle:@"取消" otherButtonTitles:nil];
            [msgbox show];
            break;
        }

        case EQQAPIQQNOTINSTALLED:
        {
            UIAlertView *msgbox = [[UIAlertView alloc] initWithTitle:@"Error" message:@"未安装手Q" delegate:nil cancelButtonTitle:@"取消" otherButtonTitles:nil];
            [msgbox show];
            break;
        }
//        case EQQAPITIMNOTINSTALLED:
//        {
//            UIAlertView *msgbox = [[UIAlertView alloc] initWithTitle:@"Error" message:@"未安装TIM" delegate:nil cancelButtonTitle:@"取消" otherButtonTitles:nil];
//            [msgbox show];
//            break;
//        }
        case EQQAPIQQNOTSUPPORTAPI:
        {
            UIAlertView *msgbox = [[UIAlertView alloc] initWithTitle:@"Error" message:@"API接口不支持" delegate:nil cancelButtonTitle:@"取消" otherButtonTitles:nil];
            [msgbox show];
            break;
        }
        case EQQAPISENDFAILD:
        {
            UIAlertView *msgbox = [[UIAlertView alloc] initWithTitle:@"Error" message:@"发送失败" delegate:nil cancelButtonTitle:@"取消" otherButtonTitles:nil];
            [msgbox show];
            break;
        }

        case EQQAPIVERSIONNEEDUPDATE:
        {
            UIAlertView *msgbox = [[UIAlertView alloc] initWithTitle:@"Error" message:@"当前QQ版本太低，需要更新" delegate:nil cancelButtonTitle:@"取消" otherButtonTitles:nil];
            [msgbox show];
            break;
        }
//        case ETIMAPIVERSIONNEEDUPDATE:
//        {
//            UIAlertView *msgbox = [[UIAlertView alloc] initWithTitle:@"Error" message:@"当前TIM版本太低，需要更新" delegate:nil cancelButtonTitle:@"取消" otherButtonTitles:nil];
//            [msgbox show];
//            break;
//        }
        default:
        {
            break;
        }
    }
}
@end
